## Partnered status AT DEATH by age
## Using ABS STAT data

## https://stat.data.abs.gov.au/Index.aspx?DatasetCode=DEATHS_MARITAL_STATUS#

## Note these stats are based on registered marital status
## https://www.abs.gov.au/AUSSTATS/abs@.nsf/Previousproducts/3302.0Glossary12014?opendocument&tabname=Notes&prodno=3302.0&issue=2014&num=&view=


# Prelims -----------------------------------------------------------------

rm(list=ls())
gc()

hilda_grouped <- qread("./Input data/Intermediate input data/hilda_grouped_master.qs")



# Read and tidy ABS death data --------------------------------------------------

abs_deaths_csv <- fread("./Input data/Intermediate input data/ABS DEATHS_MARITAL_STATUS_29062021122432104.csv")


## tidy and calc partnered rates at death
abs_partnered_death <- abs_deaths_csv %>% 
  ## keep relevant vars
  select(TIME, SEX_ABS, Sex, AGE, `Marital status`, Value) %>% 
  ## remove missing age
  filter(AGE!="999") %>% 
  ## remove "all marital statuses" and "all ages" rows
  filter(`Marital status`!="All marital statuses" & AGE!="TT") %>% 
  ## sum up males and females
  group_by(TIME, AGE, `Marital status`) %>% 
  summarise(deaths=sum(Value)) %>% 
  ## single/married, and age grouping
  mutate(partnered = ifelse(`Marital status`=="Married", 1, 0),
         age_grp_abs = str_extract(AGE, "[[:digit:]]+") ,
         ## formatting age to match format in model
         age_grp = case_when(age_grp_abs == "04" ~ "[0,5)",
                                 age_grp_abs == "59" ~ "[5,10)",
                                 age_grp_abs == "99" ~ "[100,105]",
                                 TRUE ~ paste0("[", age_grp_abs, ",", as.numeric(age_grp_abs)+5, ")")),
         age_grp = factor(age_grp, levels=levels(hilda_grouped$age_grp), ordered=T)) %>% 
  arrange(TIME, age_grp) %>% 
  ## calc married pc
  group_by(TIME, age_grp) %>% 
  summarise(partnered_pc = sum(partnered*deaths)/sum(deaths) ) %>% 
  ## average over all time
  group_by(age_grp) %>% 
  summarise(partnered_pc = mean(partnered_pc))

# ggplot(abs_partnered_death) +
#   geom_col(aes(x=age_grp, y=partnered_pc))
  
  
## save these values

qsave(abs_partnered_death, "./Input data/partnered_a.qs")